// Lab01: (A) Represent the given discrete-time (sampled data) sytem using 
//            pulse transfer function and state space forms. 
//        (B) Observe the responses of continuous-time and sampled data system.

//              scilab - 5.5.1
//              Operating System : Windows 7, 32-bit
//*****************************************************************************
//Clean the environment
close;
clear;
clc;
//****************************************************************************
//A. Representation of discrete-time models
//****************************************************************************

//State space representation
A=[0 1;-0.2 -0.1];
B=[0 1]';
C=[1 0];
D=0;
sysd=syslin('d',A,B,C,D);

// Pulse transfer function representation
Num=1;
Den=poly([0.2 0.1 1],'z','coeff');
Gz1=syslin('d',Num,Den)

//Pulse transfer function from ss model
Gz2=ss2tf(sysd)

//Response of the system with sampling time Ts=0.5 sec.

//sampling Time
Ts=0.5;
t=0:Ts:10;
u=ones(1,length(t));

y=flts(u,sysd);
plot2d2(t,y,2)
zoom_rect([0 0 10 1.2])
xgrid(35)
title('Response of discrete time system','fontsize',3)
xlabel('kT','fontsize',2)
ylabel('y(kT)','fontsize',2)

//****************************************************************************
// (B) Responses of the continuous-time and discrete-time model of the given
//     system.
//****************************************************************************

//poles of contiuous time system are at -1, -2 and -3;
den=poly([-1,-2,-3],"s",'roots');
num=1;
g=num ./den
g=syslin('c',g)
tc=0:0.2:10;
yc=csim("step",tc,g)

//Discrete-time respresentation with Ts=0.5;
sysz=dscr(g,Ts);
gz=ss2tf(sysz)
yd=flts(u,sysz);

//Responses
figure,
plot(tc,yc,'blue') //continuous time system
plot2d2(t,yd,5)   // Discrete time system
title('Responses of continuous and discrete time system','fontsize',3)
xlabel('t','fontsize',2)
ylabel('y(t), (y(kT)','fontsize',2)
f=get("current_figure") //Current figure handle                
f.background=8
xgrid(36)
h=legend('y(t)', 'y(kT)')
h.legend_location = "in_lower_right"

